// terrain shadow only_nv.vsh

uniform mat4 vc0;	// worldViewProj
uniform mat4 vc4;
uniform vec4 vc15;	// texture filtering offsets
uniform vec4 vc16;
uniform vec4 vc17;

void main()
{
	// transform position
	gl_Position = gl_Vertex * vc0;

	// Set to constant color
	gl_FrontColor = vec4(0.0, 0.0, 0.0, 0.0);
	
	// transform
	vec4 r0 = gl_Vertex * vc4;
	r0.y = 1.0 - r0.y;		// Invert y (reading from a GL buffer)
	
	//-- compute PCF Filter texture offsets
	gl_TexCoord[0] = r0 + vc15;
	gl_TexCoord[2] = r0 + vc16;
	gl_TexCoord[3] = r0 + vc17;
}

/*
vs.1.1

def c8, 0.0, 0.0, 0.0, 0.0
def c14, 0.005, 0.0, 0.0, 0.0

dcl_position0 v0

// transform position
dp4 oPos.x, v0, c[0]
dp4 oPos.y, v0, c[1]
dp4 oPos.z, v0, c[2]
dp4 oPos.w, v0, c[3]

; Set to constant color
mov oD0, c8

//-- Transform
dp4 r0.x, v0, c[4]
dp4 r0.y, v0, c[5]
dp4 r0.z, v0, c[6]
dp4 r0.w, v0, c[7]

//-- PCF Filter texture offsets
add oT0, r0, c15
add oT1, r0, c16
add oT2, r0, c17
*/